﻿using System;
using System.ComponentModel.Composition;
using Vimt.JsonWebToken.Messages;
using Vimt.JsonWebToken.Messages.Messages;
using Vimt.JsonWebToken.Processors;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;

namespace Vimt.JsonWebToken.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VimtJwtEncryptTokenRequest)]
    public class VimtJwtEncryptMessageHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                LogMessageReceipt(message);
                return new VimtJwtEncryptProcessor().Execute((VimtJwtEncryptTokenRequest)message);
            }
            catch (Exception ex)
            {
                var msg = (VimtJwtEncryptTokenRequest)message;
                LogHelper.LogError(string.Empty, Guid.Empty, "VimtJwtEncryptMessageHandler.HandleRequestResponse", ex);
                throw new Exception(string.Format("VimtJwtEncryptMessageHandler Error: {0}", ex.Message), ex);
            }
        }
    }
}